/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import net.minecraft.class_2561;

public class UltraHeatChallenge
extends Challenge {
    private static final float DEFAULT_SENSITIVITY = 1.0f;
    private static final String SETTING_SENSITIVITY = "sensitivity";
    public static final float MIN_SENSITIVITY = 0.1f;
    public static final float MAX_SENSITIVITY = 3.0f;
    public static final float MIN_TICK_SPEED = 0.0f;
    public static final float MAX_TICK_SPEED = 1.0f;

    public UltraHeatChallenge() {
        super("ultra_heat", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.ultra_heat.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.ultra_heat.description"), true, Challenge.MultiplayerStatus.EXPERIMENTAL);
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_SENSITIVITY)) {
            this.setSensitivity(1.0f);
        }
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.resetTimeSpeed();
    }

    @Override
    public void onDisable() {
        this.resetTimeSpeed();
    }

    public float getSensitivity() {
        return (float)ChallengeSettings.getIntOption(this.getId(), SETTING_SENSITIVITY, 100) / 100.0f;
    }

    public void setSensitivity(float sensitivity) {
        ChallengeSettings.setIntOption(this.getId(), SETTING_SENSITIVITY, (int)(sensitivity * 100.0f));
    }

    public void resetTimeSpeed() {
    }

    public float calculateTickSpeed(float movementSpeed, float cameraMovement) {
        if (!this.isEnabled()) {
            return 1.0f;
        }
        float totalMovement = Math.max(movementSpeed, cameraMovement);
        if (totalMovement <= 0.001f) {
            return 0.0f;
        }
        float adjustedMovement = totalMovement * this.getSensitivity();
        float tickSpeed = Math.max(0.0f, Math.min(1.0f, adjustedMovement));
        return tickSpeed;
    }
}

